package org.msh.tb.reports2.me;

import org.msh.tb.reports2.ReportResources;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 8/12/16.
 */
public class CohortReport {

    public static List<TableData> generate(IndicatorBuilder builder) {
        List<TableData> tables = new ArrayList<TableData>();

        tables.add(generateTable1(builder));

        tables.add(generateTable2(builder.clear()));

        tables.add(generateTable3(builder.clear()));

        return tables;
    }

    private static TableData generateTable1(IndicatorBuilder builder) {
        String col = "groups OUTCOME='Treatment outcomes'," +
                "totalcases key=1:'Total TB cases registered'," +
                "outcome group=OUTCOME outdate=notnull, " +
                "totalcases group=OUTCOME outdate=notnull";

        TableData tbl = builder
                .addColumnVariables(col)
                .addRowVariables("patient-type-rep")
                .addFilter("patient-type-rep", "notnull")
                .generate("Block 1: Treatment outcome for all TB cases registered by case category");

        return tbl;
    }

    private static TableData generateTable2(IndicatorBuilder builder) {
        String col = "groups OUTCOME='Treatment outcomes'," +
                "totalcases key=1:'Total TB cases registered'," +
                "outcome group=OUTCOME outdate=notnull, " +
                "totalcases group=OUTCOME outdate=notnull";

        String row = "caseDef caseDef=notnull," +
                "is is=notnull," +
                "hivres hivres=POSITIVE key=POSITIVE:'HIV-Positive TB Cases' ";

        TableData tbl = builder
                .addColumnVariables(col)
                .addRowVariables(row)
                .generate("Block 2: Treatment outcome for all TB cases registered by type of service provided");
        return tbl;
    }


    private static TableData generateTable3(IndicatorBuilder builder) {
        String col = "groups OUTCOME='Treatment outcomes'," +
                "totalcases key=1:'Total TB cases registered'," +
                "outcome group=OUTCOME outdate=notnull, " +
                "totalcases group=OUTCOME outdate=notnull";

        TableData tbl = builder
                .addColumnVariables(col)
                .addRowVariables("patient-type-rep", "ageRange2")
                .generate("Block 2: Treatment outcome for all TB cases registered by type of service provided");
        return tbl;
    }

}
